package gov.va.med.mhv.admin.dto;

import gov.va.med.mhv.admin.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.admin.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.admin.enums.PerformerTypeEnumeration;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivitySearchCriteriaDTO implements Serializable {

	private static final long serialVersionUID = 5818259809508562100L;

	private Date fromDate;
	private Date toDate;
	private String performerType;
	private String userName;

	public Date getFromDate() {
		return fromDate;
	}

	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public Date getToDate() {
		return toDate;
	}

	public void setToDate(Date toDate) {
		if (toDate != null) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(toDate);
			int year = calendar.get(Calendar.YEAR);
			int month = calendar.get(Calendar.MONTH);
			int date = calendar.get(Calendar.DATE);
			calendar.set(year, month, date, 23, 59, 59);

			this.toDate = calendar.getTime();
		}
	}

	public String getPerformerType() {
		return performerType;
	}

	public void setPerformerType(String performerType) {
		this.performerType = performerType;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@JsonIgnore
	public PerformerTypeEnumeration[] getPerformerTypes() {
		return PerformerTypeEnumeration.values();
	}

	@JsonIgnore
	public ActivityActionTypeEnumeration[] getActivityActions() {
		return ActivityActionTypeEnumeration.values();
	}

	@JsonIgnore
	public ActivityActorTypeEnumeration[] getActivityActorTypes() {
		return ActivityActorTypeEnumeration.values();
	}

}
